# SSCG - Simple Signed Certificate Generator

<a href="https://scan.coverity.com/projects/sscg">
  <img alt="Coverity Scan Build Status"
       src="https://scan.coverity.com/projects/12070/badge.svg"/>
</a>

## Why?
x509 Certificates are complicated to get right. SSCG makes it easy to generate usable, _signed_ certificates quickly without needing to understand complex `openssl`, `certtool` or `certutil` commands.

## Quick Usage - Certificates Signed by a Private CA
```
/usr/bin/sscg
````
This will produce a `ca.crt` and a pair of `service.pem` and `service-key.pem` files in the current directory, the latter of which is signed by the private key of the `ca.crt`. The CA's private key will be destroyed by default after these files are created, so nothing further can be signed by it. (See [this blog post](https://sgallagh.wordpress.com/2016/05/02/self-signed-ssltls-certificates-why-they-are-terrible-and-a-better-alternative/)  for details on why this is desirable.)

Certificates generated by SSCG will be valid by default for securing the current machine's hostname and no others. To add further names (such as for a multi-homed system), look at the `--subject-alt-name` argument below.


## Full Usage
Usage of sscg:
```
Usage: sscg [OPTION...]
  -q, --quiet                                           Display no output unless there is an error.
  -v, --verbose                                         Display progress messages.
  -d, --debug                                           Enable logging of debug messages. Implies verbose. Warning! This will print
                                                        private key information to the screen!
  -V, --version                                         Display the version number and exit.
      --lifetime=1-3650                                 Certificate lifetime (days). (default: 3650)
      --country=US, CZ, etc.                            Certificate DN: Country (C). (default: "US")
      --state=Massachusetts, British Columbia, etc.     Certificate DN: State or Province (ST).
      --locality=Westford, Paris, etc.                  Certificate DN: Locality (L).
      --organization=My Company                         Certificate DN: Organization (O). (default: "Unspecified")
      --organizational-unit=Engineering, etc.           Certificate DN: Organizational Unit (OU).
      --hostname=server.example.com                     The valid hostname of the certificate. Must be an FQDN. (default: current system
                                                        FQDN)
      --subject-alt-name alt.example.com                Optional additional valid hostnames for the certificate. May be specified multiple
                                                        times.
      --package=STRING                                  Unused. Retained for compatibility with earlier versions of sscg.
      --key-strength={512,1024,2048,4096}               Strength of the certificate private keys in bits. (default: 2048)
      --hash-alg={sha256,sha384,sha512}                 Hashing algorithm to use for signing. (default: sha256)
      --ca-file=STRING                                  Path where the public CA certificate will be stored. (default: "./ca.crt")
      --ca-key-file=STRING                              Path where the CA's private key will be stored. If unspecified, the key will be
                                                        destroyed rather than written to the disk.
      --cert-file=STRING                                Path where the public service certificate will be stored. (default "./service.pem")
      --cert-key-file=STRING                            Path where the service's private key will be stored. (default "service-key.pem")

Help options:
  -?, --help                                            Show this help message
      --usage                                           Display brief usage message

```
