#!/usr/bin/perl -w

package KeyboardNames;

%models = (
    'A4Tech KB-21' => 'a4techKB21',
    'A4Tech KBS-8' => 'a4techKBS8',
    'A4Tech Wireless Desktop RFKB-23' => 'a4_rfkb23',
    'Acer AirKey V' => 'airkey',
    'Acer C300' => 'acer_c300',
    'Acer Ferrari 4000' => 'acer_ferrari4k',
    'Acer laptop' => 'acer_laptop',
    'Advance Scorpius KI' => 'scorpius',
    'Amiga' => 'amiga',
    'Apple' => 'apple',
    'Apple Aluminium (ANSI)' => 'applealu_ansi',
    'Apple Aluminium (ISO)' => 'applealu_iso',
    'Apple Aluminium (JIS)' => 'applealu_jis',
    'Apple laptop' => 'apple_laptop',
    'Asus laptop' => 'asus_laptop',
    'Atari TT' => 'ataritt',
    'Azona RF2300 wireless Internet' => 'azonaRF2300',
    'BTC 5090' => 'btc5090',
    'BTC 5113RF Multimedia' => 'btc5113rf',
    'BTC 5126T' => 'btc5126t',
    'BTC 6301URF' => 'btc6301urf',
    'BTC 9000' => 'btc9000',
    'BTC 9000A' => 'btc9000a',
    'BTC 9001AH' => 'btc9001ah',
    'BTC 9019U' => 'btc9019u',
    'BTC 9116U Mini Wireless Internet and Gaming' => 'btc9116u',
    'BenQ X-Touch' => 'benqx',
    'BenQ X-Touch 730' => 'benqx730',
    'BenQ X-Touch 800' => 'benqx800',
    'Brother Internet' => 'brother',
    'Cherry B.UNLIMITED' => 'cherrybunlim',
    'Cherry Blue Line CyBo@rd' => 'cherryblue',
    'Cherry Blue Line CyBo@rd (alt.)' => 'cherrybluea',
    'Cherry CyBo@rd USB-Hub' => 'cherrycyboard',
    'Cherry CyMotion Expert' => 'cherrycmexpert',
    'Cherry CyMotion Master Linux' => 'cymotionlinux',
    'Cherry CyMotion Master XPress' => 'cherryblueb',
    'Chicony Internet' => 'chicony',
    'Chicony KB-9885' => 'chicony9885',
    'Chicony KU-0108' => 'chicony0108',
    'Chicony KU-0420' => 'chicony0420',
    'Chromebook' => 'chromebook',
    'Classmate PC' => 'classmate',
    'Compaq Armada laptop' => 'armada',
    'Compaq Easy Access' => 'compaqeak8',
    'Compaq Internet (13 keys)' => 'compaqik13',
    'Compaq Internet (18 keys)' => 'compaqik18',
    'Compaq Internet (7 keys)' => 'compaqik7',
    'Compaq Presario laptop' => 'presario',
    'Compaq iPaq' => 'ipaq',
    'Creative Desktop Wireless 7000' => 'creativedw7000',
    'DTK2000' => 'dtk2000',
    'Dell' => 'dell',
    'Dell 101-key PC' => 'dell101',
    'Dell Inspiron 6000/8000 laptop' => 'inspiron',
    'Dell Latitude laptop' => 'latitude',
    'Dell Precision M laptop' => 'precision_m',
    'Dell Precision M65 laptop' => 'dellm65',
    'Dell SK-8125' => 'dellsk8125',
    'Dell SK-8135' => 'dellsk8135',
    'Dell USB Multimedia' => 'dellusbmm',
    'Dexxa Wireless Desktop' => 'dexxa',
    'Diamond 9801/9802' => 'diamond',
    'Ennyah DKB-1008' => 'ennyah_dkb1008',
    'Everex STEPnote' => 'everex',
    'FL90' => 'compalfl90',
    'Fujitsu-Siemens Amilo laptop' => 'fscaa1667g',
    'Generic 101-key PC' => 'pc101',
    'Generic 102-key PC (intl.)' => 'pc102',
    'Generic 104-key PC' => 'pc104',
    'Generic 105-key PC (intl.)' => 'pc105',
    'Genius Comfy KB-12e' => 'geniuscomfy',
    'Genius Comfy KB-16M/Multimedia KWD-910' => 'genius',
    'Genius Comfy KB-21e-Scroll' => 'geniuscomfy2',
    'Genius KB-19e NB' => 'geniuskb19e',
    'Genius KKB-2050HS' => 'geniuskkb2050hs',
    'Gyration' => 'gyration',
    'Happy Hacking' => 'hhk',
    'Happy Hacking for Mac' => 'macintosh_hhk',
    'Hewlett-Packard Internet' => 'hpi6',
    'Hewlett-Packard Mini 110 laptop' => 'hpmini110',
    'Hewlett-Packard NEC SK-2500 Multimedia' => 'hp250x',
    'Hewlett-Packard Omnibook 500' => 'hp5xx',
    'Hewlett-Packard Omnibook 500 FA' => 'hp500fa',
    'Hewlett-Packard Omnibook 6000/6100' => 'hp6000',
    'Hewlett-Packard Omnibook XE3 GC' => 'hpxe3gc',
    'Hewlett-Packard Omnibook XE3 GF' => 'hpxe3gf',
    'Hewlett-Packard Omnibook XT1000' => 'hpxt1000',
    'Hewlett-Packard Pavilion ZT1100' => 'hpzt11xx',
    'Hewlett-Packard Pavilion dv5' => 'hpdv5',
    'Hewlett-Packard nx9020' => 'hpnx9020',
    'Honeywell Euroboard' => 'honeywell_euroboard',
    'IBM Rapid Access' => 'rapidaccess',
    'IBM Rapid Access II' => 'rapidaccess2',
    'IBM Space Saver' => 'ibm_spacesaver',
    'IBM ThinkPad 560Z/600/600E/A22E' => 'thinkpad',
    'IBM ThinkPad R60/T60/R61/T61' => 'thinkpad60',
    'IBM ThinkPad Z60m/Z60t/Z61m/Z61t' => 'thinkpadz60',
    'Keytronic FlexPro' => 'flexpro',
    'Kinesis' => 'kinesis',
    'Logitech' => 'logitech_base',
    'Logitech Access' => 'logiaccess',
    'Logitech Cordless Desktop' => 'logicd',
    'Logitech Cordless Desktop (alt.)' => 'logicda',
    'Logitech Cordless Desktop EX110' => 'logiex110',
    'Logitech Cordless Desktop LX-300' => 'logiclx300',
    'Logitech Cordless Desktop Navigator' => 'logicdn',
    'Logitech Cordless Desktop Optical' => 'logicd_opt',
    'Logitech Cordless Desktop Pro (2nd alt.)' => 'logicdpa2',
    'Logitech Cordless Desktop iTouch' => 'logicd_it',
    'Logitech Cordless Freedom/Desktop Navigator' => 'logicfn',
    'Logitech G15 extra keys via G15daemon' => 'logitech_g15',
    'Logitech Internet' => 'logiik',
    'Logitech Internet 350' => 'logimel',
    'Logitech Internet Navigator' => 'logicink',
    'Logitech Ultra-X' => 'logiultrax',
    'Logitech Ultra-X Cordless Media Desktop' => 'logiultraxc',
    'Logitech diNovo' => 'logidinovo',
    'Logitech diNovo Edge' => 'logidinovoedge',
    'Logitech iTouch' => 'itouch',
    'Logitech iTouch Cordless Y-RB6' => 'logiitc',
    'Logitech iTouch Internet Navigator SE' => 'logiinkse',
    'Logitech iTouch Internet Navigator SE USB' => 'logiinkseusb',
    'MacBook/MacBook Pro' => 'macbook78',
    'MacBook/MacBook Pro (intl.)' => 'macbook79',
    'Macintosh' => 'macintosh',
    'Macintosh Old' => 'macintosh_old',
    'Memorex MX1998' => 'mx1998',
    'Memorex MX2500 EZ-Access' => 'mx2500',
    'Memorex MX2750' => 'mx2750',
    'Microsoft Comfort Curve 2000' => 'microsoftccurve2k',
    'Microsoft Internet' => 'microsoftinet',
    'Microsoft Internet Pro (Swedish)' => 'microsoftprose',
    'Microsoft Natural' => 'microsoft',
    'Microsoft Natural Elite' => 'microsoftelite',
    'Microsoft Natural Ergonomic 4000' => 'microsoft4000',
    'Microsoft Natural Pro OEM' => 'microsoftprooem',
    'Microsoft Natural Pro USB/Internet Pro' => 'microsoftprousb',
    'Microsoft Natural Pro/Internet Pro' => 'microsoftpro',
    'Microsoft Natural Wireless Ergonomic 7000' => 'microsoft7000',
    'Microsoft Office Keyboard' => 'microsoftoffice',
    'Microsoft Surface' => 'microsoftsurface',
    'Microsoft Wireless Multimedia 1.0A' => 'microsoftmult',
    'NEC SK-1300' => 'sk1300',
    'NEC SK-2500' => 'sk2500',
    'NEC SK-6200' => 'sk6200',
    'NEC SK-7100' => 'sk7100',
    'Northgate OmniKey 101' => 'omnikey101',
    'OLPC' => 'olpc',
    'Ortek Multimedia/Internet MCK-800' => 'oretec',
    'PC-98' => 'pc98',
    'Propeller Voyager KTEZ-1000' => 'propeller',
    'QTronix Scorpius 98N+' => 'qtronix',
    'SVEN Ergonomic 2500' => 'sven',
    'SVEN Slim 303' => 'sven303',
    'Samsung SDM 4500P' => 'samsung4500',
    'Samsung SDM 4510P' => 'samsung4510',
    'Sanwa Supply SKB-KG3' => 'sanwaskbkg3',
    'Silvercrest Multimedia Wireless' => 'silvercrest',
    'SteelSeries Apex 300 (Apex RAW)' => 'apex300',
    'Sun Type 4' => 'sun4',
    'Sun Type 5' => 'sun5',
    'Sun Type 6 (Japanese)' => 'sun_type6_jp',
    'Sun Type 6 USB (Japanese)' => 'sun_type6_jp_usb',
    'Sun Type 6 USB (Unix)' => 'sun_type6_unix_usb',
    'Sun Type 6/7 USB' => 'sun_type6_usb',
    'Sun Type 6/7 USB (European)' => 'sun_type6_euro_usb',
    'Sun Type 7 USB' => 'sun_type7_usb',
    'Sun Type 7 USB (European)' => 'sun_type7_euro_usb',
    'Sun Type 7 USB (Japanese)/Japanese 106-key' => 'sun_type7_jp_usb',
    'Sun Type 7 USB (Unix)' => 'sun_type7_unix_usb',
    'Super Power Multimedia' => 'sp_inet',
    'Symplon PaceBook tablet' => 'symplon',
    'Targa Visionary 811' => 'targa_v811',
    'Toshiba Satellite S3000' => 'toshiba_s3000',
    'Truly Ergonomic 227' => 'teck227',
    'Truly Ergonomic 229' => 'teck229',
    'Truly Ergonomic Computer Keyboard Model 227 (Wide Alt keys)' => 'teck227',
    'Truly Ergonomic Computer Keyboard Model 229 (Standard sized Alt keys, additional Super and Menu key)' => 'teck229',
    'Trust Direct Access' => 'trustda',
    'Trust Slimline' => 'trust_slimline',
    'Trust Wireless Classic' => 'trust',
    'TypeMatrix EZ-Reach 2020' => 'tm2020',
    'TypeMatrix EZ-Reach 2030 PS2' => 'tm2030PS2',
    'TypeMatrix EZ-Reach 2030 USB' => 'tm2030USB',
    'TypeMatrix EZ-Reach 2030 USB (102/105:EU mode)' => 'tm2030USB-102',
    'TypeMatrix EZ-Reach 2030 USB (106:JP mode)' => 'tm2030USB-106',
    'Unitek KB-1925' => 'unitekkb1925',
    'ViewSonic KU-306 Internet' => 'vsonku306',
    'Winbook Model XP5' => 'winbook',
    'Yahoo! Internet' => 'yahoo',
    'eMachines m6800 laptop' => 'emachines',
);

%layouts = (
    'Afghani' => 'af',
    'Albanian' => 'al',
    'Amharic' => 'et',
    'Arabic' => 'ara',
    'Arabic (Morocco)' => 'ma',
    'Arabic (Syria)' => 'sy',
    'Armenian' => 'am',
    'Azerbaijani' => 'az',
    'Bambara' => 'ml',
    'Bangla' => 'bd',
    'Belarusian' => 'by',
    'Belgian' => 'be',
    'Berber (Algeria, Latin)' => 'dz',
    'Bosnian' => 'ba',
    'Braille' => 'brai',
    'Bulgarian' => 'bg',
    'Burmese' => 'mm',
    'Chinese' => 'cn',
    'Croatian' => 'hr',
    'Czech' => 'cz',
    'Danish' => 'dk',
    'Dhivehi' => 'mv',
    'Dutch' => 'nl',
    'Dzongkha' => 'bt',
    'English (Australian)' => 'au',
    'English (Cameroon)' => 'cm',
    'English (Ghana)' => 'gh',
    'English (Nigeria)' => 'ng',
    'English (South Africa)' => 'za',
    'English (UK)' => 'gb',
    'English (US)' => 'us',
    'Esperanto' => 'epo',
    'Estonian' => 'ee',
    'Faroese' => 'fo',
    'Filipino' => 'ph',
    'Finnish' => 'fi',
    'French' => 'fr',
    'French (Canada)' => 'ca',
    'French (Democratic Republic of the Congo)' => 'cd',
    'French (Guinea)' => 'gn',
    'French (Togo)' => 'tg',
    'Georgian' => 'ge',
    'German' => 'de',
    'German (Austria)' => 'at',
    'German (Switzerland)' => 'ch',
    'Greek' => 'gr',
    'Hebrew' => 'il',
    'Hungarian' => 'hu',
    'Icelandic' => 'is',
    'Indian' => 'in',
    'Indonesian (Arab Melayu, phonetic)' => 'id',
    'Indonesian (Javanese)' => 'jv',
    'Iraqi' => 'iq',
    'Irish' => 'ie',
    'Italian' => 'it',
    'Japanese' => 'jp',
    'Japanese (PC-98)' => 'nec_vndr/jp',
    'Kazakh' => 'kz',
    'Khmer (Cambodia)' => 'kh',
    'Korean' => 'kr',
    'Kyrgyz' => 'kg',
    'Lao' => 'la',
    'Latvian' => 'lv',
    'Lithuanian' => 'lt',
    'Macedonian' => 'mk',
    'Malay (Jawi, Arabic Keyboard)' => 'my',
    'Maltese' => 'mt',
    'Maori' => 'mao',
    'Moldavian' => 'md',
    'Mongolian' => 'mn',
    'Montenegrin' => 'me',
    'Nepali' => 'np',
    'Norwegian' => 'no',
    'Persian' => 'ir',
    'Polish' => 'pl',
    'Portuguese' => 'pt',
    'Portuguese (Brazil)' => 'br',
    'Romanian' => 'ro',
    'Russian' => 'ru',
    'Serbian' => 'rs',
    'Sinhala (phonetic)' => 'lk',
    'Slovak' => 'sk',
    'Slovenian' => 'si',
    'Spanish' => 'es',
    'Spanish (Latin American)' => 'latam',
    'Swahili (Kenya)' => 'ke',
    'Swahili (Tanzania)' => 'tz',
    'Swedish' => 'se',
    'Taiwanese' => 'tw',
    'Tajik' => 'tj',
    'Thai' => 'th',
    'Tswana' => 'bw',
    'Turkish' => 'tr',
    'Turkmen' => 'tm',
    'Ukrainian' => 'ua',
    'Urdu (Pakistan)' => 'pk',
    'Uzbek' => 'uz',
    'Vietnamese' => 'vn',
    'Wolof' => 'sn',
);

%variants = (
    'af' => {
	'Pashto' => 'ps',
	'Pashto (Afghanistan, OLPC)' => 'olpc-ps',
	'Persian (Afghanistan, Dari OLPC)' => 'fa-olpc',
	'Uzbek (Afghanistan)' => 'uz',
	'Uzbek (Afghanistan, OLPC)' => 'uz-olpc',
    },
    'al' => {
	'Albanian (Plisi)' => 'plisi',
	'Albanian (Veqilharxhi)' => 'veqilharxhi',
    },
    'am' => {
	'Armenian (alt. eastern)' => 'eastern-alt',
	'Armenian (alt. phonetic)' => 'phonetic-alt',
	'Armenian (eastern)' => 'eastern',
	'Armenian (phonetic)' => 'phonetic',
	'Armenian (western)' => 'western',
    },
    'ara' => {
	'Arabic (AZERTY)' => 'azerty',
	'Arabic (AZERTY/digits)' => 'azerty_digits',
	'Arabic (Buckwalter)' => 'buckwalter',
	'Arabic (Macintosh)' => 'mac',
	'Arabic (OLPC)' => 'olpc',
	'Arabic (QWERTY)' => 'qwerty',
	'Arabic (digits)' => 'digits',
	'Arabic (qwerty/digits)' => 'qwerty_digits',
    },
    'at' => {
	'German (Austria, Macintosh)' => 'mac',
	'German (Austria, no dead keys)' => 'nodeadkeys',
	'German (Austria, with Sun dead keys)' => 'sundeadkeys',
    },
    'az' => {
	'Azerbaijani (Cyrillic)' => 'cyrillic',
    },
    'ba' => {
	'Bosnian (US, with Bosnian digraphs)' => 'unicodeus',
	'Bosnian (US, with Bosnian letters)' => 'us',
	'Bosnian (with Bosnian digraphs)' => 'unicode',
	'Bosnian (with guillemets)' => 'alternatequotes',
    },
    'bd' => {
	'Bangla (Probhat)' => 'probhat',
    },
    'be' => {
	'Belgian (Wang 724 AZERTY)' => 'wang',
	'Belgian (alt. ISO)' => 'iso-alternate',
	'Belgian (alt.)' => 'oss',
	'Belgian (alt., Latin-9 only)' => 'oss_latin9',
	'Belgian (alt., with Sun dead keys)' => 'oss_sundeadkeys',
	'Belgian (no dead keys)' => 'nodeadkeys',
	'Belgian (with Sun dead keys)' => 'sundeadkeys',
    },
    'bg' => {
	'Bulgarian (new phonetic)' => 'bas_phonetic',
	'Bulgarian (traditional phonetic)' => 'phonetic',
    },
    'br' => {
	'Esperanto (Brazil, Nativo)' => 'nativo-epo',
	'Portuguese (Brazil, Dvorak)' => 'dvorak',
	'Portuguese (Brazil, IBM/Lenovo ThinkPad)' => 'thinkpad',
	'Portuguese (Brazil, Nativo for US keyboards)' => 'nativo-us',
	'Portuguese (Brazil, Nativo)' => 'nativo',
	'Portuguese (Brazil, no dead keys)' => 'nodeadkeys',
    },
    'brai' => {
	'Braille (left-handed inverted thumb)' => 'left_hand_invert',
	'Braille (left-handed)' => 'left_hand',
	'Braille (right-handed inverted thumb)' => 'right_hand_invert',
	'Braille (right-handed)' => 'right_hand',
    },
    'by' => {
	'Belarusian (Latin)' => 'latin',
	'Belarusian (legacy)' => 'legacy',
    },
    'ca' => {
	'Canadian Multilingual' => 'multix',
	'Canadian Multilingual (1st part)' => 'multi',
	'Canadian Multilingual (2nd part)' => 'multi-2gr',
	'English (Canada)' => 'eng',
	'French (Canada, Dvorak)' => 'fr-dvorak',
	'French (Canada, legacy)' => 'fr-legacy',
	'Inuktitut' => 'ike',
    },
    'ch' => {
	'French (Switzerland)' => 'fr',
	'French (Switzerland, Macintosh)' => 'fr_mac',
	'French (Switzerland, no dead keys)' => 'fr_nodeadkeys',
	'French (Switzerland, with Sun dead keys)' => 'fr_sundeadkeys',
	'German (Switzerland, Macintosh)' => 'de_mac',
	'German (Switzerland, legacy)' => 'legacy',
	'German (Switzerland, no dead keys)' => 'de_nodeadkeys',
	'German (Switzerland, with Sun dead keys)' => 'de_sundeadkeys',
    },
    'cm' => {
	'Cameroon Multilingual (AZERTY)' => 'azerty',
	'Cameroon Multilingual (Dvorak)' => 'dvorak',
	'Cameroon Multilingual (QWERTY)' => 'qwerty',
	'French (Cameroon)' => 'french',
	'Mmuock' => 'mmuock',
    },
    'cn' => {
	'Hanyu Pinyin (altgr)' => 'altgr-pinyin',
	'Mongolian (Bichig)' => 'mon_trad',
	'Mongolian Galik' => 'mon_trad_galik',
	'Mongolian Manchu' => 'mon_trad_manchu',
	'Mongolian Manchu Galik' => 'mon_manchu_galik',
	'Mongolian Todo' => 'mon_trad_todo',
	'Mongolian Todo Galik' => 'mon_todo_galik',
	'Mongolian Xibe' => 'mon_trad_xibe',
	'Tibetan' => 'tib',
	'Tibetan (with ASCII numerals)' => 'tib_asciinum',
	'Uyghur' => 'ug',
    },
    'cz' => {
	'Czech (QWERTY)' => 'qwerty',
	'Czech (QWERTY, Macintosh)' => 'qwerty-mac',
	'Czech (QWERTY, extended backslash)' => 'qwerty_bksl',
	'Czech (UCW, only accented letters)' => 'ucw',
	'Czech (US, Dvorak, UCW support)' => 'dvorak-ucw',
	'Czech (with <\|> key)' => 'bksl',
	'Russian (Czech, phonetic)' => 'rus',
    },
    'de' => {
	'German (Dvorak)' => 'dvorak',
	'German (Macintosh)' => 'mac',
	'German (Macintosh, no dead keys)' => 'mac_nodeadkeys',
	'German (Neo 2)' => 'neo',
	'German (QWERTY)' => 'qwerty',
	'German (T3)' => 'T3',
	'German (dead acute)' => 'deadacute',
	'German (dead grave acute)' => 'deadgraveacute',
	'German (dead tilde)' => 'deadtilde',
	'German (no dead keys)' => 'nodeadkeys',
	'German (with Sun dead keys)' => 'sundeadkeys',
	'Lower Sorbian' => 'dsb',
	'Lower Sorbian (QWERTZ)' => 'dsb_qwertz',
	'Romanian (Germany)' => 'ro',
	'Romanian (Germany, no dead keys)' => 'ro_nodeadkeys',
	'Russian (Germany, phonetic)' => 'ru',
	'Turkish (Germany)' => 'tr',
    },
    'dk' => {
	'Danish (Dvorak)' => 'dvorak',
	'Danish (Macintosh)' => 'mac',
	'Danish (Macintosh, no dead keys)' => 'mac_nodeadkeys',
	'Danish (Win keys)' => 'winkeys',
	'Danish (no dead keys)' => 'nodeadkeys',
    },
    'dz' => {
	'Arabic (Algeria)' => 'ar',
	'Berber (Algeria, Tifinagh)' => 'ber',
    },
    'ee' => {
	'Estonian (Dvorak)' => 'dvorak',
	'Estonian (US, with Estonian letters)' => 'us',
	'Estonian (no dead keys)' => 'nodeadkeys',
    },
    'epo' => {
	'Esperanto (displaced semicolon and quote, obsolete)' => 'legacy',
    },
    'es' => {
	'Asturian (Spain, with bottom-dot H and bottom-dot L)' => 'ast',
	'Catalan (Spain, with middle-dot L)' => 'cat',
	'Spanish (Dvorak)' => 'dvorak',
	'Spanish (Macintosh)' => 'mac',
	'Spanish (Win keys)' => 'winkeys',
	'Spanish (dead tilde)' => 'deadtilde',
	'Spanish (no dead keys)' => 'nodeadkeys',
	'Spanish (with Sun dead keys)' => 'sundeadkeys',
    },
    'fi' => {
	'Finnish (Macintosh)' => 'mac',
	'Finnish (Winkeys)' => 'winkeys',
	'Finnish (classic)' => 'classic',
	'Finnish (classic, no dead keys)' => 'nodeadkeys',
	'Northern Saami (Finland)' => 'smi',
    },
    'fo' => {
	'Faroese (no dead keys)' => 'nodeadkeys',
    },
    'fr' => {
	'French (AFNOR standardized AZERTY)' => 'afnor',
	'French (AZERTY)' => 'azerty',
	'French (Bepo, ergonomic, Dvorak way)' => 'bepo',
	'French (Bepo, ergonomic, Dvorak way, AFNOR)' => 'bepo_afnor',
	'French (Bepo, ergonomic, Dvorak way, Latin-9 only)' => 'bepo_latin9',
	'French (Breton)' => 'bre',
	'French (Dvorak)' => 'dvorak',
	'French (Macintosh)' => 'mac',
	'French (US, with French letters)' => 'us',
	'French (alt.)' => 'oss',
	'French (alt., Latin-9 only)' => 'oss_latin9',
	'French (alt., no dead keys)' => 'oss_nodeadkeys',
	'French (alt., with Sun dead keys)' => 'oss_sundeadkeys',
	'French (legacy, alt.)' => 'latin9',
	'French (legacy, alt., no dead keys)' => 'latin9_nodeadkeys',
	'French (legacy, alt., with Sun dead keys)' => 'latin9_sundeadkeys',
	'French (no dead keys)' => 'nodeadkeys',
	'French (with Sun dead keys)' => 'sundeadkeys',
	'Georgian (France, AZERTY Tskapo)' => 'geo',
	'Occitan' => 'oci',
    },
    'gb' => {
	'English (UK, Colemak)' => 'colemak',
	'English (UK, Dvorak)' => 'dvorak',
	'English (UK, Dvorak, with UK punctuation)' => 'dvorakukp',
	'English (UK, Macintosh)' => 'mac',
	'English (UK, extended, with Win keys)' => 'extd',
	'English (UK, intl., Macintosh)' => 'mac_intl',
	'English (UK, intl., with dead keys)' => 'intl',
	'Polish (British keyboard)' => 'pl',
    },
    'ge' => {
	'Georgian (MESS)' => 'mess',
	'Georgian (ergonomic)' => 'ergonomic',
	'Ossetian (Georgia)' => 'os',
	'Russian (Georgia)' => 'ru',
    },
    'gh' => {
	'Akan' => 'akan',
	'Avatime' => 'avn',
	'English (Ghana, GILLBT)' => 'gillbt',
	'English (Ghana, multilingual)' => 'generic',
	'Ewe' => 'ewe',
	'Fula' => 'fula',
	'Ga' => 'ga',
	'Hausa (Ghana)' => 'hausa',
    },
    'gr' => {
	'Greek (extended)' => 'extended',
	'Greek (no dead keys)' => 'nodeadkeys',
	'Greek (polytonic)' => 'polytonic',
	'Greek (simple)' => 'simple',
    },
    'hr' => {
	'Croatian (US, with Croatian digraphs)' => 'unicodeus',
	'Croatian (US, with Croatian letters)' => 'us',
	'Croatian (with Croatian digraphs)' => 'unicode',
	'Croatian (with guillemets)' => 'alternatequotes',
    },
    'hu' => {
	'Hungarian (101/QWERTY/comma/dead keys)' => '101_qwerty_comma_dead',
	'Hungarian (101/QWERTY/comma/no dead keys)' => '101_qwerty_comma_nodead',
	'Hungarian (101/QWERTY/dot/dead keys)' => '101_qwerty_dot_dead',
	'Hungarian (101/QWERTY/dot/no dead keys)' => '101_qwerty_dot_nodead',
	'Hungarian (101/QWERTZ/comma/dead keys)' => '101_qwertz_comma_dead',
	'Hungarian (101/QWERTZ/comma/no dead keys)' => '101_qwertz_comma_nodead',
	'Hungarian (101/QWERTZ/dot/dead keys)' => '101_qwertz_dot_dead',
	'Hungarian (101/QWERTZ/dot/no dead keys)' => '101_qwertz_dot_nodead',
	'Hungarian (102/QWERTY/comma/dead keys)' => '102_qwerty_comma_dead',
	'Hungarian (102/QWERTY/comma/no dead keys)' => '102_qwerty_comma_nodead',
	'Hungarian (102/QWERTY/dot/dead keys)' => '102_qwerty_dot_dead',
	'Hungarian (102/QWERTY/dot/no dead keys)' => '102_qwerty_dot_nodead',
	'Hungarian (102/QWERTZ/comma/dead keys)' => '102_qwertz_comma_dead',
	'Hungarian (102/QWERTZ/comma/no dead keys)' => '102_qwertz_comma_nodead',
	'Hungarian (102/QWERTZ/dot/dead keys)' => '102_qwertz_dot_dead',
	'Hungarian (102/QWERTZ/dot/no dead keys)' => '102_qwertz_dot_nodead',
	'Hungarian (QWERTY)' => 'qwerty',
	'Hungarian (no dead keys)' => 'nodeadkeys',
	'Hungarian (standard)' => 'standard',
    },
    'id' => {
	'Indonesian (Arab Melayu, ext. phonetic)' => 'phoneticx',
    },
    'ie' => {
	'CloGaelach' => 'CloGaelach',
	'Irish (UnicodeExpert)' => 'UnicodeExpert',
	'Ogham' => 'ogam',
	'Ogham (IS434)' => 'ogam_is434',
    },
    'il' => {
	'Hebrew (Biblical, Tiro)' => 'biblical',
	'Hebrew (lyx)' => 'lyx',
	'Hebrew (phonetic)' => 'phonetic',
    },
    'in' => {
	'Bangla (India)' => 'ben',
	'Bangla (India, Baishakhi Inscript)' => 'ben_inscript',
	'Bangla (India, Baishakhi)' => 'ben_baishakhi',
	'Bangla (India, Bornona)' => 'ben_bornona',
	'Bangla (India, Probhat)' => 'ben_probhat',
	'Bangla (India, Uni Gitanjali)' => 'ben_gitanjali',
	'English (India, with rupee)' => 'eng',
	'Gujarati' => 'guj',
	'Hindi (Bolnagri)' => 'bolnagri',
	'Hindi (KaGaPa phonetic)' => 'hin-kagapa',
	'Hindi (Wx)' => 'hin-wx',
	'Kannada' => 'kan',
	'Kannada (KaGaPa phonetic)' => 'kan-kagapa',
	'Malayalam' => 'mal',
	'Malayalam (Lalitha)' => 'mal_lalitha',
	'Malayalam (enhanced Inscript, with rupee)' => 'mal_enhanced',
	'Manipuri (Eeyek)' => 'eeyek',
	'Marathi (KaGaPa phonetic)' => 'mar-kagapa',
	'Ol Chiki' => 'olck',
	'Oriya' => 'ori',
	'Punjabi (Gurmukhi Jhelum)' => 'jhelum',
	'Punjabi (Gurmukhi)' => 'guru',
	'Sanskrit (KaGaPa phonetic)' => 'san-kagapa',
	'Tamil (Inscript)' => 'tam',
	'Tamil (TamilNet 99 with Tamil numerals)' => 'tam_tamilnet_with_tam_nums',
	'Tamil (TamilNet 99)' => 'tam_tamilnet',
	'Tamil (TamilNet 99, TAB encoding)' => 'tam_tamilnet_TAB',
	'Tamil (TamilNet 99, TSCII encoding)' => 'tam_tamilnet_TSCII',
	'Telugu' => 'tel',
	'Telugu (KaGaPa phonetic)' => 'tel-kagapa',
	'Telugu (Sarala)' => 'tel-sarala',
	'Urdu (Win keys)' => 'urd-winkeys',
	'Urdu (alt. phonetic)' => 'urd-phonetic3',
	'Urdu (phonetic)' => 'urd-phonetic',
    },
    'iq' => {
	'Kurdish (Iraq, Arabic-Latin)' => 'ku_ara',
	'Kurdish (Iraq, F)' => 'ku_f',
	'Kurdish (Iraq, Latin Alt-Q)' => 'ku_alt',
	'Kurdish (Iraq, Latin Q)' => 'ku',
    },
    'ir' => {
	'Kurdish (Iran, Arabic-Latin)' => 'ku_ara',
	'Kurdish (Iran, F)' => 'ku_f',
	'Kurdish (Iran, Latin Alt-Q)' => 'ku_alt',
	'Kurdish (Iran, Latin Q)' => 'ku',
	'Persian (with Persian keypad)' => 'pes_keypad',
    },
    'is' => {
	'Icelandic (Dvorak)' => 'dvorak',
	'Icelandic (Macintosh)' => 'mac',
	'Icelandic (Macintosh, legacy)' => 'mac_legacy',
	'Icelandic (no dead keys)' => 'nodeadkeys',
	'Icelandic (with Sun dead keys)' => 'Sundeadkeys',
    },
    'it' => {
	'Friulian (Italy)' => 'fur',
	'Georgian (Italy)' => 'geo',
	'Italian (IBM 142)' => 'ibm',
	'Italian (Macintosh)' => 'mac',
	'Italian (US, with Italian letters)' => 'us',
	'Italian (Winkeys)' => 'winkeys',
	'Italian (intl., with dead keys)' => 'intl',
	'Italian (no dead keys)' => 'nodeadkeys',
	'Sicilian' => 'scn',
    },
    'jp' => {
	'Japanese (Dvorak)' => 'dvorak',
	'Japanese (Kana 86)' => 'kana86',
	'Japanese (Kana)' => 'kana',
	'Japanese (Macintosh)' => 'mac',
	'Japanese (OADG 109A)' => 'OADG109A',
    },
    'ke' => {
	'Kikuyu' => 'kik',
    },
    'kg' => {
	'Kyrgyz (phonetic)' => 'phonetic',
    },
    'kr' => {
	'Korean (101/104 key compatible)' => 'kr104',
    },
    'kz' => {
	'Kazakh (Latin)' => 'latin',
	'Kazakh (extended)' => 'ext',
	'Kazakh (with Russian)' => 'kazrus',
	'Russian (Kazakhstan, with Kazakh)' => 'ruskaz',
    },
    'la' => {
	'Lao (STEA proposed standard layout)' => 'stea',
    },
    'latam' => {
	'Spanish (Latin American, Colemak for gaming)' => 'colemak-gaming',
	'Spanish (Latin American, Colemak)' => 'colemak',
	'Spanish (Latin American, Dvorak)' => 'dvorak',
	'Spanish (Latin American, dead tilde)' => 'deadtilde',
	'Spanish (Latin American, no dead keys)' => 'nodeadkeys',
	'Spanish (Latin American, with Sun dead keys)' => 'sundeadkeys',
    },
    'lk' => {
	'Sinhala (US, with Sinhala letters)' => 'us',
	'Tamil (Sri Lanka, TamilNet 99)' => 'tam_unicode',
	'Tamil (Sri Lanka, TamilNet 99, TAB encoding)' => 'tam_TAB',
    },
    'lt' => {
	'Lithuanian (IBM LST 1205-92)' => 'ibm',
	'Lithuanian (LEKP)' => 'lekp',
	'Lithuanian (LEKPa)' => 'lekpa',
	'Lithuanian (US, with Lithuanian letters)' => 'us',
	'Lithuanian (standard)' => 'std',
	'Samogitian' => 'sgs',
    },
    'lv' => {
	'Latvian (F)' => 'fkey',
	'Latvian (adapted)' => 'adapted',
	'Latvian (apostrophe)' => 'apostrophe',
	'Latvian (ergonomic, ŪGJRMV)' => 'ergonomic',
	'Latvian (modern)' => 'modern',
	'Latvian (tilde)' => 'tilde',
    },
    'ma' => {
	'Berber (Morocco, Tifinagh alt. phonetic)' => 'tifinagh-alt-phonetic',
	'Berber (Morocco, Tifinagh alt.)' => 'tifinagh-alt',
	'Berber (Morocco, Tifinagh extended phonetic)' => 'tifinagh-extended-phonetic',
	'Berber (Morocco, Tifinagh extended)' => 'tifinagh-extended',
	'Berber (Morocco, Tifinagh phonetic)' => 'tifinagh-phonetic',
	'Berber (Morocco, Tifinagh)' => 'tifinagh',
	'French (Morocco)' => 'french',
    },
    'md' => {
	'Moldavian (Gagauz)' => 'gag',
    },
    'me' => {
	'Montenegrin (Cyrillic with guillemets)' => 'cyrillicalternatequotes',
	'Montenegrin (Cyrillic)' => 'cyrillic',
	'Montenegrin (Cyrillic, ZE and ZHE swapped)' => 'cyrillicyz',
	'Montenegrin (Latin with guillemets)' => 'latinalternatequotes',
	'Montenegrin (Latin, QWERTY)' => 'latinyz',
	'Montenegrin (Latin, Unicode)' => 'latinunicode',
	'Montenegrin (Latin, Unicode, QWERTY)' => 'latinunicodeyz',
    },
    'mk' => {
	'Macedonian (no dead keys)' => 'nodeadkeys',
    },
    'ml' => {
	'English (Mali, US, Macintosh)' => 'us-mac',
	'English (Mali, US, intl.)' => 'us-intl',
	'French (Mali, alt.)' => 'fr-oss',
    },
    'mm' => {
	'Burmese Zawgyi' => 'zawgyi',
    },
    'mt' => {
	'Maltese (UK layout with AltGr overrides)' => 'alt-gb',
	'Maltese (US layout with AltGr overrides)' => 'alt-us',
	'Maltese (with US layout)' => 'us',
    },
    'my' => {
	'Malay (Jawi, phonetic)' => 'phonetic',
    },
    'ng' => {
	'Hausa (Nigeria)' => 'hausa',
	'Igbo' => 'igbo',
	'Yoruba' => 'yoruba',
    },
    'nl' => {
	'Dutch (Macintosh)' => 'mac',
	'Dutch (standard)' => 'std',
	'Dutch (with Sun dead keys)' => 'sundeadkeys',
    },
    'no' => {
	'Northern Saami (Norway)' => 'smi',
	'Northern Saami (Norway, no dead keys)' => 'smi_nodeadkeys',
	'Norwegian (Colemak)' => 'colemak',
	'Norwegian (Dvorak)' => 'dvorak',
	'Norwegian (Macintosh)' => 'mac',
	'Norwegian (Macintosh, no dead keys)' => 'mac_nodeadkeys',
	'Norwegian (Win keys)' => 'winkeys',
	'Norwegian (no dead keys)' => 'nodeadkeys',
    },
    'ph' => {
	'Filipino (Capewell-Dvorak, Baybayin)' => 'capewell-dvorak-bay',
	'Filipino (Capewell-Dvorak, Latin)' => 'capewell-dvorak',
	'Filipino (Capewell-QWERF 2006, Baybayin)' => 'capewell-qwerf2k6-bay',
	'Filipino (Capewell-QWERF 2006, Latin)' => 'capewell-qwerf2k6',
	'Filipino (Colemak, Baybayin)' => 'colemak-bay',
	'Filipino (Colemak, Latin)' => 'colemak',
	'Filipino (Dvorak, Baybayin)' => 'dvorak-bay',
	'Filipino (Dvorak, Latin)' => 'dvorak',
	'Filipino (QWERTY, Baybayin)' => 'qwerty-bay',
    },
    'pk' => {
	'Arabic (Pakistan)' => 'ara',
	'Sindhi' => 'snd',
	'Urdu (Pakistan, CRULP)' => 'urd-crulp',
	'Urdu (Pakistan, NLA)' => 'urd-nla',
    },
    'pl' => {
	'Kashubian' => 'csb',
	'Polish (Dvorak)' => 'dvorak',
	'Polish (Dvorak, with Polish quotes on key 1)' => 'dvorak_altquotes',
	'Polish (Dvorak, with Polish quotes on quotemark key)' => 'dvorak_quotes',
	'Polish (QWERTZ)' => 'qwertz',
	'Polish (legacy)' => 'legacy',
	'Polish (programmer Dvorak)' => 'dvp',
	'Russian (Poland, phonetic Dvorak)' => 'ru_phonetic_dvorak',
	'Silesian' => 'szl',
    },
    'pt' => {
	'Esperanto (Portugal, Nativo)' => 'nativo-epo',
	'Portuguese (Macintosh)' => 'mac',
	'Portuguese (Macintosh, no dead keys)' => 'mac_nodeadkeys',
	'Portuguese (Macintosh, with Sun dead keys)' => 'mac_sundeadkeys',
	'Portuguese (Nativo for US keyboards)' => 'nativo-us',
	'Portuguese (Nativo)' => 'nativo',
	'Portuguese (no dead keys)' => 'nodeadkeys',
	'Portuguese (with Sun dead keys)' => 'sundeadkeys',
    },
    'ro' => {
	'Romanian (Win keys)' => 'winkeys',
	'Romanian (cedilla)' => 'cedilla',
	'Romanian (standard cedilla)' => 'std_cedilla',
	'Romanian (standard)' => 'std',
    },
    'rs' => {
	'Pannonian Rusyn' => 'rue',
	'Serbian (Cyrillic with guillemets)' => 'alternatequotes',
	'Serbian (Cyrillic, ZE and ZHE swapped)' => 'yz',
	'Serbian (Latin with guillemets)' => 'latinalternatequotes',
	'Serbian (Latin)' => 'latin',
	'Serbian (Latin, QWERTY)' => 'latinyz',
	'Serbian (Latin, Unicode)' => 'latinunicode',
	'Serbian (Latin, Unicode, QWERTY)' => 'latinunicodeyz',
    },
    'ru' => {
	'Bashkirian' => 'bak',
	'Chuvash' => 'cv',
	'Chuvash (Latin)' => 'cv_latin',
	'Kalmyk' => 'xal',
	'Komi' => 'kom',
	'Mari' => 'chm',
	'Ossetian (Win keys)' => 'os_winkeys',
	'Ossetian (legacy)' => 'os_legacy',
	'Russian (DOS)' => 'dos',
	'Russian (Macintosh)' => 'mac',
	'Russian (legacy)' => 'legacy',
	'Russian (phonetic yazherty)' => 'phonetic_yazherty',
	'Russian (phonetic)' => 'phonetic',
	'Russian (phonetic, AZERTY)' => 'phonetic_azerty',
	'Russian (phonetic, Dvorak)' => 'phonetic_dvorak',
	'Russian (phonetic, French)' => 'phonetic_fr',
	'Russian (phonetic, with Win keys)' => 'phonetic_winkeys',
	'Russian (typewriter)' => 'typewriter',
	'Russian (typewriter, legacy)' => 'typewriter-legacy',
	'Serbian (Russia)' => 'srp',
	'Tatar' => 'tt',
	'Udmurt' => 'udm',
	'Yakut' => 'sah',
    },
    'se' => {
	'Northern Saami (Sweden)' => 'smi',
	'Russian (Sweden, phonetic)' => 'rus',
	'Russian (Sweden, phonetic, no dead keys)' => 'rus_nodeadkeys',
	'Swedish (Dvorak)' => 'dvorak',
	'Swedish (Macintosh)' => 'mac',
	'Swedish (Svdvorak)' => 'svdvorak',
	'Swedish (US, with Swedish letters)' => 'us',
	'Swedish (based on US Intl. Dvorak)' => 'us_dvorak',
	'Swedish (no dead keys)' => 'nodeadkeys',
	'Swedish Sign Language' => 'swl',
    },
    'si' => {
	'Slovenian (US, with Slovenian letters)' => 'us',
	'Slovenian (with guillemets)' => 'alternatequotes',
    },
    'sk' => {
	'Slovak (QWERTY)' => 'qwerty',
	'Slovak (QWERTY, extended backslash)' => 'qwerty_bksl',
	'Slovak (extended backslash)' => 'bksl',
    },
    'sy' => {
	'Kurdish (Syria, F)' => 'ku_f',
	'Kurdish (Syria, Latin Alt-Q)' => 'ku_alt',
	'Kurdish (Syria, Latin Q)' => 'ku',
	'Syriac' => 'syc',
	'Syriac (phonetic)' => 'syc_phonetic',
    },
    'th' => {
	'Thai (Pattachote)' => 'pat',
	'Thai (TIS-820.2538)' => 'tis',
    },
    'tj' => {
	'Tajik (legacy)' => 'legacy',
    },
    'tm' => {
	'Turkmen (Alt-Q)' => 'alt',
    },
    'tr' => {
	'Crimean Tatar (Turkish Alt-Q)' => 'crh_alt',
	'Crimean Tatar (Turkish F)' => 'crh_f',
	'Crimean Tatar (Turkish Q)' => 'crh',
	'Kurdish (Turkey, F)' => 'ku_f',
	'Kurdish (Turkey, Latin Alt-Q)' => 'ku_alt',
	'Kurdish (Turkey, Latin Q)' => 'ku',
	'Turkish (Alt-Q)' => 'alt',
	'Turkish (F)' => 'f',
	'Turkish (intl., with dead keys)' => 'intl',
	'Turkish (with Sun dead keys)' => 'sundeadkeys',
    },
    'tw' => {
	'Saisiyat (Taiwan)' => 'saisiyat',
	'Taiwanese (indigenous)' => 'indigenous',
    },
    'ua' => {
	'Russian (Ukraine, standard RSTU)' => 'rstu_ru',
	'Ukrainian (Win keys)' => 'winkeys',
	'Ukrainian (homophonic)' => 'homophonic',
	'Ukrainian (legacy)' => 'legacy',
	'Ukrainian (phonetic)' => 'phonetic',
	'Ukrainian (standard RSTU)' => 'rstu',
	'Ukrainian (typewriter)' => 'typewriter',
    },
    'us' => {
	'Cherokee' => 'chr',
	'English (Colemak)' => 'colemak',
	'English (Dvorak)' => 'dvorak',
	'English (Dvorak, alt. intl.)' => 'dvorak-alt-intl',
	'English (Dvorak, intl., with dead keys)' => 'dvorak-intl',
	'English (Dvorak, left-handed)' => 'dvorak-l',
	'English (Dvorak, right-handed)' => 'dvorak-r',
	'English (Macintosh)' => 'mac',
	'English (Norman)' => 'norman',
	'English (US, alt. intl.)' => 'alt-intl',
	'English (US, euro on 5)' => 'euro',
	'English (US, intl., with dead keys)' => 'intl',
	'English (Workman)' => 'workman',
	'English (Workman, intl., with dead keys)' => 'workman-intl',
	'English (classic Dvorak)' => 'dvorak-classic',
	'English (intl., with AltGr dead keys)' => 'altgr-intl',
	'English (programmer Dvorak)' => 'dvp',
	'English (the divide/multiply keys toggle the layout)' => 'olpc2',
	'Russian (US, phonetic)' => 'rus',
	'Serbo-Croatian (US)' => 'hbs',
    },
    'uz' => {
	'Uzbek (Latin)' => 'latin',
    },
    'vn' => {
	'Vietnamese (French, with Vietnamese letters)' => 'fr',
	'Vietnamese (US, with Vietnamese letters)' => 'us',
    },
);

1;
